//******************************************
// file			: main.c
// version		: V1.0 2021/03/25
// brief		: main program
// note			: 
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif
#include "MQ6811.h"
#include "MQ6801_REG_BIT.h"
//*****************************************************
//-- header guards --//
#ifndef	uchar
#define uchar unsigned char
#endif
#ifndef	uint
#define uint  unsigned int
#endif
#ifndef	ulong
#define ulong unsigned long
#endif

//-- declare function --//
void delay_times(uchar tBase, uint x);
void Ext_Interrupt_Init();




//-- global variables --//
uchar flag_WUC;


//-- global constants --//
const uchar t_1ms   = 0;
const uchar t_100us = 1;
const uchar t_6u    = 2;	//HIRC: 8MHz, CGCR/4
const uchar t_3u    = 3;	//HIRC:16MHz, CGCR/4




void main()
{
//-----Disable P10 Reset-----set P10 to GPIO pin
//	SYSCR3.byte = 0x01;
//	SYSCR4.byte = 0xB2;

	P1DR.byte = 0x00;
	P1CR.byte = 0xff;
	P4DR.byte = 0x00;
	P4CR.byte = 0xff;
	P7DR.byte = 0x00;
	P7CR.byte = 0xff;
	P8DR.byte = 0x00;
	P8CR.byte = 0xff;
	P9DR.byte = 0x00;
	P9CR.byte = 0xff;


	WDCDR.byte = 0x4e;				// clear wdt
//----------------------------------------//
//	External Interrupt ............

//-----------------------------------------------------------------------
//	MQ6801 P40/P75, P41/P76, P47/P77, are shared pins
//	need to switch when use external interrupt function(INT2/INT3/INT4) <--> (P75/P76/P77)
//	as follows
//		1. software setting
//			INT5 ==> FSCTRL.bit.b5 = 0(P75), 1=P40(default Ϊ 1)
//			INT6 ==> FSCTRL.bit.b4 = 0(P76), 1=P41(default Ϊ 1)
//			INT7 ==> FSCTRL.bit.b2 = 0(P77), 1=P47(default Ϊ 1)
//		   and another pin :
//			FSCTRL.bit.b3 = 0(P70), 1=P46(default Ϊ 1)
//		2. IDE : click Project -> Pin Setting, then generate a page with optional pin settings
//		3. Writer : click Type, then generate a page with optional pin settings
//----------------------------------------------------------------------
//	Interrupt condition:
//		MQ6801:			(Falling/Rising/Both/HI) level
//		44-pin ev board:	(Falling/Rising/Both), no "HI" option
	Ext_Interrupt_Init();





	WDCDR.byte = 0x4e;				// clear wdt
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	while(1)
	{
		WDCDR.byte = 0x4e;			// clear wdt
#ifdef _DEBUG
		__asm("CPL (_P8DR).0");		// when using ev board, toggle P80
		__asm("CPL (_P8DR).0");		// when using ev board, toggle P80
		__asm("CPL (_P8DR).0");		// when using ev board, toggle P80
		__asm("CPL (_P8DR).0");		// when using ev board, toggle P80
#else
		__asm("CPL (_P8DR).1");		// MQ6801 toggle P81
		__asm("CPL (_P8DR).1");		// MQ6801 toggle P81
		__asm("CPL (_P8DR).1");		// MQ6801 toggle P81
		__asm("CPL (_P8DR).1");		// MQ6801 toggle P81
#endif
	}
//* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
}






//*********************************************************************
// name			: Ext_Interrupt_Init()
// brief		: External Interrupt Control
// note			: 1. (INT2/INT3/INT4) <--> (P75/P76/P77)
// 				: 2. MQ6801 interrupt condition as  (Falling/Rising/Both/HI)
// 				:    44-pin emulation interrupt condition (Falling/Rising/Both), no "HI" option
//*********************************************************************
void Ext_Interrupt_Init()
{
#ifdef _DEBUG	//... _DEBUG: for emulation of ev board
	__asm("DI");
//.........................
//... external interrupt INT2 setting
	P7CR.bit.b5    = 0;		// set interrupt as input mode
	POFFCR3.bit.b2 = 1;		// INTx input enable
	ILE.bit.b2     = 0;		// clear INTx interrupt latch
	EIRE.bit.b2    = 1;		// INTx interrupt enable
	EINTCR2.byte   = 0x00;	// set Rising edge,
//	EINTCR2.byte   = 0x04;	// set Falling edge,
//	EINTCR2.byte   = 0x08;	// set Both edge,

//.........................
//... external interrupt INT3 setting
	P7CR.bit.b6    = 0;		// set interrupt as input mode
	POFFCR3.bit.b3 = 1;		// INTx input enable
	ILE.bit.b3     = 0;		// clear INTx interrupt latch
	EIRE.bit.b3    = 1;		// INTx interrupt enable
	EINTCR3.byte   = 0x00;	// set Rising edge,
//	EINTCR3.byte   = 0x04;	// set Falling edge,
//	EINTCR3.byte   = 0x08;	// set Both edge,

//.........................
//... external interrupt INT4 setting
	P7CR.bit.b7    = 0;		// set interrupt as input mode
	POFFCR3.bit.b4 = 1;		// INTx input enable
	ILE.bit.b4     = 0;		// clear INTx interrupt latch
	EIRE.bit.b4    = 1;		// INTx interrupt enable
	EINTCR4.byte   = 0x00;	// set Rising edge,
//	EINTCR4.byte   = 0x04;	// set Falling edge,
//	EINTCR4.byte   = 0x08;	// set Both edge,
//.........................
	__asm("EI");

#else	//...	//... MQ6801 Release Version
	__asm("DI");
//.........................
//... external interrupt INT2 setting
	P7CR.bit.b5    = 0;		// set interrupt as input mode
	POFFCR3.bit.b2 = 1;		// INTx input enable
	ILE.bit.b2     = 0;		// clear INTx interrupt latch
	EIRE.bit.b2    = 1;		// INTx interrupt enable
	EINTCR2.byte   = 0x00;	// set Rising edge,
//	EINTCR2.byte   = 0x04;	// set Falling edge,
//	EINTCR2.byte   = 0x08;	// set Both edge,
//	EINTCR2.byte   = 0x0C;	// set HI level.

//.........................
//... external interrupt INT3 setting
	P7CR.bit.b6    = 0;		// set interrupt as input mode
	POFFCR3.bit.b3 = 1;		// INTx input enable
	ILE.bit.b3     = 0;		// clear INTx interrupt latch
	EIRE.bit.b3    = 1;		// INTx interrupt enable
	EINTCR3.byte   = 0x00;	// set Rising edge,
//	EINTCR3.byte   = 0x04;	// set Falling edge,
//	EINTCR3.byte   = 0x08;	// set Both edge,
//	EINTCR3.byte   = 0x0C;	// set HI level.

//.........................
//... external interrupt INT4 setting
	P7CR.bit.b7    = 0;		// set interrupt as input mode
	POFFCR3.bit.b4 = 1;		// INTx input enable
	ILE.bit.b4     = 0;		// clear INTx interrupt latch
	EIRE.bit.b4    = 1;		// INTx interrupt enable
	EINTCR4.byte   = 0x00;	// set Rising edge,
//	EINTCR4.byte   = 0x04;	// set Falling edge,
//	EINTCR4.byte   = 0x08;	// set Both edge,
//	EINTCR4.byte   = 0x0C;	// set HI level.
//.........................
	__asm("EI");
#endif
}


//*********************************************************************
// name			: delay_times(uchar tBase, uint x)
// brief		: time delay function
// note			: ==> t_1ms   = 0;
// 				: ==> t_100us = 1;
// 				: ==> t_6u    = 2;	//HIRC: 8MHz, CGCR/4
// 				: ==> t_3u    = 3;	//HIRC:16MHz, CGCR/4
// 				: ...
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
	uint  i, cgcrT;
	uchar cgcrF[4]={ 2, 4,  8, 1 };		// HIRC =>  8MHz
//	uchar cgcrF[4]={ 4, 8, 16, 2 };		// HIRC => 16MHz

	cgcrT = cgcrF[CGCR.byte];			// 0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
	switch(tBase){
		case 0:		// t_1ms
			cgcrT *= 110;
			for(; x>0; x--)
				for(i=0; i<cgcrT; i++){}
			break;
		case 1:		// t_100us
			cgcrT *= 11;
			for(; x>0; x--)
				for(i=0; i<cgcrT; i++){}
			break;
		case 2:		// t_6u				// HIRC: 8MHz, CGCR/4
			for(; x>0; x--){}
			break;
		case 3:		// t_3u				// HIRC:16MHz, CGCR/4
			for(; x>0; x--){}
			break;
	}
	WDCDR.byte=0x4e; 			// clear wdt
}





